/*
 * Decompiled with CFR 0.152.
 */
package sufftracker;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.HashMap;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.LayoutStyle;
import sufftracker.BeamerContestantPanel;
import sufftracker.ContentFrame;
import sufftracker.Contestant;
import sufftracker.DataHolder;
import sufftracker.SettingsHolder;
import sufftracker.Window;

public class BeamerView
extends ContentFrame {
    private Window w;
    private HashMap<String, BeamerContestantPanel> contestantPanels = new HashMap();
    DataHolder data;
    private JPanel contestantArea;
    private JButton jButton1;
    private JButton jButton2;
    private JButton jButton3;
    private JButton jButton4;
    private JPanel jPanel15;

    public BeamerView(Window w, DataHolder d) {
        this.w = w;
        this.data = d;
        this.data.addObserver(this);
        this.initComponents();
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                BeamerView.this.close();
            }
        });
        SettingsHolder s = SettingsHolder.instance();
        this.setBounds(s.getInt("beamerX", 0), s.getInt("beamerY", 0), 800, 600);
        this.setTitle("SuffTracker - Beamer");
        this.setVisible(true);
        int m = this.data.getMax();
        for (Contestant ct : this.data.getAllContestants()) {
            BeamerContestantPanel bcp = new BeamerContestantPanel(ct);
            bcp.setCurrentMax(m);
            this.contestantArea.add(bcp);
            this.contestantPanels.put(ct.latest.person, bcp);
        }
        this.contentChanged();
    }

    public void close() {
        SettingsHolder s = SettingsHolder.instance();
        s.put("beamerX", this.getLocation().x);
        s.put("beamerY", this.getLocation().y);
        this.w.close();
    }

    private void initComponents() {
        this.jPanel15 = new JPanel();
        this.jButton1 = new JButton();
        this.jButton2 = new JButton();
        this.jButton3 = new JButton();
        this.jButton4 = new JButton();
        this.contestantArea = new JPanel();
        this.setDefaultCloseOperation(3);
        this.setBackground(new Color(204, 204, 204));
        this.setPreferredSize(new Dimension(800, 600));
        this.jPanel15.setBackground(new Color(204, 204, 204));
        this.jPanel15.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        GroupLayout jPanel15Layout = new GroupLayout(this.jPanel15);
        this.jPanel15.setLayout(jPanel15Layout);
        jPanel15Layout.setHorizontalGroup(jPanel15Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 592, Short.MAX_VALUE));
        jPanel15Layout.setVerticalGroup(jPanel15Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 0, Short.MAX_VALUE));
        this.jButton1.setFont(new Font("Cambria", 0, 14));
        this.jButton1.setText("Tagesverlauf");
        this.jButton2.setFont(new Font("Cambria", 0, 14));
        this.jButton2.setText("Einstellungen");
        this.jButton3.setFont(new Font("Cambria", 0, 14));
        this.jButton3.setText("Gesamtverlauf");
        this.jButton3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BeamerView.this.jButton3ActionPerformed(evt);
            }
        });
        this.jButton4.setFont(new Font("Cambria", 0, 14));
        this.jButton4.setText("Punkte nach Tagen");
        GroupLayout contestantAreaLayout = new GroupLayout(this.contestantArea);
        this.contestantArea.setLayout(contestantAreaLayout);
        contestantAreaLayout.setHorizontalGroup(contestantAreaLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 0, Short.MAX_VALUE));
        contestantAreaLayout.setVerticalGroup(contestantAreaLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 230, Short.MAX_VALUE));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.contestantArea, -1, -1, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.jPanel15, -1, -1, Short.MAX_VALUE).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jButton3, GroupLayout.Alignment.TRAILING, -1, 150, Short.MAX_VALUE).addComponent(this.jButton1, GroupLayout.Alignment.TRAILING, -1, 150, Short.MAX_VALUE).addComponent(this.jButton4, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addComponent(this.jButton2, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE)))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.contestantArea, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jButton1, -2, 40, -2).addGap(18, 18, 18).addComponent(this.jButton3, -2, 40, -2).addGap(18, 18, 18).addComponent(this.jButton4, -2, 40, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 110, Short.MAX_VALUE).addComponent(this.jButton2, -2, 40, -2)).addComponent(this.jPanel15, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        this.pack();
    }

    private void jButton3ActionPerformed(ActionEvent evt) {
    }

    @Override
    public void contentChanged() {
        int i = 0;
        for (Contestant ct : this.data.getAllContestants()) {
            BeamerContestantPanel bcp = this.contestantPanels.get(ct.latest.person);
            bcp.setCurrentMax(this.data.getMax());
            bcp.amountChanged();
            int c = i % 6;
            bcp.moveTo((int)((double)c * 130.5), i / 6 * 120);
            ++i;
        }
    }

    @Override
    public void contentAdded(String name) {
        BeamerContestantPanel p = new BeamerContestantPanel(this.data.contestant(name));
        p.setCurrentMax(this.data.getMax());
        this.contestantArea.add(p);
        this.contestantPanels.put(name, p);
        this.contentChanged();
    }
}

